//Listing 12.2. Tworzenie obiektu zoonego bez niepotrzebnych wywoa konstruktora
#include <iostream>
using namespace std;

class Point {
  private:
    int x, y; // wsprzdne prywatne
  public:
    Point (int a=0, int b=0) // konstruktor oglny
    { x = a; y = b;
      cout << " Utworzony: x= " << x << " y=" << y << endl; }
    Point (const Point& pt) // konstruktor kopiujcy
    { x = pt.x; y = pt.y;
      cout << " Skopiowany: x= " << x << " y=" << y << endl; }
    void operator = (const Point& pt) // operator przypisania
    { x = pt.x; y = pt.y;
      cout << " Przypisany: x= " << x << " y=" << y << endl; }
    void set (int a, int b) // funkcja modyfikatora
    { x = a; y = b; }
    void move (int a, int b) // funkcja modyfikatora
    { x += a; y += b; }
    void get (int& a, int& b) const // funkcja selektora
    { a = x; b = y; } } ;

  class Rectangle {
    Point pt1, pt2; // wsprzdne grnego lewego oraz dolnego prawego punktu
    int thickness; // szeroko obramowania prostokta
  public:
    Rectangle (const Point& p1, const Point& p2, int width=1);
    void move(int a, int b); // przesu oba punkty
    bool pointIn(const Point& pt) const; // czy punkt w prostokcie?
    } ;

Rectangle::Rectangle(const Point& p1, const Point& p2,int w)
: thickness(w), pt1(p1), pt2(p2) // lista inicjalizujca
{ } // pusta tre skadowej

void Rectangle::move(int a, int b)
  { pt1.move(a,b); pt2.move(a,b); } // przeka dane do obiektu klasy Point

bool Rectangle::pointIn(const Point& pt) const // czy punkt jest wewntrz?
  { int x,y,x1,y1,x2,y2; // wsprzdne punktu oraz wierzchokw
    pt.get(x,y); // pobierz wsprzdne parametru
    pt1.get(x1,y1); pt2.get(x2,y2); // pobierz dane z wierzchokw
    bool xIsBetweenBorders = (x1<x && x<x2) || (x2<x && x<x1);
    bool yIsBetweenBorders = (y>y1 && y<y2) || (y<y1 && y>y2);
    return (xIsBetweenBorders && yIsBetweenBorders); }

int main()
{ Point p1(20,40), p2(70,90); // wierzchoki lewy grny oraz prawy dolny
  Point point(100,120); // punkt do przechwycenia przez prostokt
  Rectangle rec(p1,p2,4); // BRAK niepotrzebnego wywoania konstruktora
  point.move(-25,-15); // przesu punkt po ekranie
  rec.move(10,20); // 10 pikseli w prawo, 20 pikseli w d
  if (rec.pointIn(point)) cout << " Punkt jest wewntrz\n"; // czy punkt jest w prostokcie?
  return 0;
}
